<?php

namespace App\Modules\GroupProvider\Application\Index;

use App\Modules\GroupProvider\Application\GroupProviderResponse;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderIndexer $indexer)
    {
    }

    public function __invoke(IndexGroupProviderQuery $query): GroupProviderResponse
    {
        $model = $this->indexer->__invoke(new IdGroupProvider($query->id()));
        return new GroupProviderResponse(
            $model->id()->value(),
            $model->type()->value(),
            $model->remark()->value(),
            $model->answeredReview()->value(),
            $model->mask()->value(),
            $model->isCloned()->value(),
            $model->mediaStatus()->value(),
            $model->mediaScore()->value(),
            $model->idGroup()->value(),
            $model->idProvider()->value(),
            $model->idTypeProvider()->value(),
            $model->idStatusGroupProvider()->value(),
        );
    }
}
