<?php

namespace App\Modules\GroupProvider\Application\DeleteMedia;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteMediaGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupProviderMediaDeleter $deleter
    ) {
    }

    public function __invoke(DeleteMediaGroupProviderQuery $query): DeleteMediaGroupProviderResponse
    {
        $response = $this->deleter->__invoke(new IdGroupProvider($query->id()));
        return new DeleteMediaGroupProviderResponse($response);
    }
}
