<?php

namespace App\Modules\GroupPassengerMedia\Application\List;

use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaRepository;
use App\Modules\GroupPassengerMedia\Domain\ListGroupPassengerMedia;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;

final class GroupPassengerMediaLister
{
    public function __construct(private GroupPassengerMediaRepository $repository)
    {
    }

    public function __invoke(IdGroupPassenger $idGroupPassenger, string $action)
    {
        return $this->repository->search(new ListGroupPassengerMedia($idGroupPassenger, $action));
    }
}
