<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

/**
 * @extends StorageCriteria<GroupPassenger>
 */
class ListGalleryGroupPassenger implements StorageCriteria
{

    private $actionList = [
        'all' => '(1, 2, 3, 4, 5, 6)',
        'downloaded' => '(6)',
        'not_downloaded' => '(2, 3, 4, 5)',
        'pending' => '(1)'
    ];

    public function __construct(
        private DateStart $dateStart,
        private DateEnd $dateEnd,
        private string $search,
        private string $action,
        private QueryPaginate $queryPaginate
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupPassengerModel::select('`gp`');

        $where = '`gp`.`GroupPassenger_MediaDateUpdate` BETWEEN ? AND ?';
        $data[] = $this->dateStart->value() . ' 00:00:00';
        $data[] = $this->dateEnd->value() . ' 23:59:59';

        $where .= ' AND `gp`.`GroupPassenger_MediaStatus` IN ' . $this->findActionElement($this->action);
        // dd("SELECT $select
        //         FROM `t_group_passenger` `gp`
        //         WHERE $where
        //         ORDER BY `gp`.`GroupPassenger_MediaDateUpdate`");
        // dd($where);

        return DB::select(
            "SELECT `frm_aux`.*,

                    `p`.`Passenger_DateCreate`,
                    `p`.`Passenger_DateEdit`,
                    `p`.`Passenger_Name`,
                    `p`.`Passenger_LastName`,
                    `p`.`Passenger_Email`,
                    `p`.`Passenger_Phone`,
                    `p`.`Passenger_PhoneCode`,
                    `p`.`Passenger_Gender`,
                    `p`.`Passenger_DOB`,
                    `p`.`Passenger_NoDocument`,
                    `p`.`Passenger_DateEntrance`,
                    `p`.`Passenger_Restriction`,
                    `p`.`Passenger_Extras`,
                    `p`.`Passenger_Order`,
                    `p`.`Passenger_ImgDocument1`,
                    `p`.`Passenger_ImgDocument2`,
                    `p`.`Passenger_Reportable`,
                    `p`.`Passenger_Status`,
                    `p`.`Passenger_PaymentStatus`,
                    `p`.`Passenger_InfoStatus`,
                    `p`.`Passenger_CheckedInStatus`,
                    `p`.`Passenger_ConfirmMessage`,
                    `p`.`Passenger_Full`,
                    `p`.`Id_Booking`,
                    `p`.`Id_TypeDocument`,
                    `p`.`Id_UserCountry`,
                    `p`.`Id_TypeRate`,

                    `g`.`Group_Date`,
                    `g`.`Group_DateUpdate`,
                    `g`.`Group_DateStart`,
                    `g`.`Group_DateEnd`,
                    `g`.`Group_Hour`,
                    `g`.`Group_Name`,
                    `g`.`Group_Token`,
                    `g`.`Group_Origin`,
                    `g`.`Group_Destination`,
                    `g`.`Group_Type`,
                    `g`.`Group_Order`,
                    `g`.`Group_TourDuration`,
                    `g`.`Group_Remark`,
                    `g`.`Group_MasterType`,
                    `g`.`Group_ServiceType`,
                    `g`.`Group_NoValidPassengers`,
                    `g`.`Group_ValidPassengers`,
                    `g`.`Group_Status`,
                    `g`.`Id_Master`,
                    `g`.`Id_Service`,
                    `g`.`Id_StatusGroup`,

                    `t`.`Id_Tour`,
                    `t`.`Tour_Code`,
                    `t`.`Tour_Name`,
                    `t`.`Tour_UrlThumbnail`,
                    `t`.`Tour_Duration`,
                    `t`.`Tour_MinPax`,
                    `t`.`Tour_Availability`,
                    `t`.`Tour_AvailabilityStatus`,
                    `t`.`Tour_Anticipation`,
                    `t`.`Tour_AnticipationType`,
                    `t`.`Tour_Color`,
                    `t`.`Tour_Score`,
                    `t`.`Tour_ScoreCant`,
                    `t`.`Tour_ScoreTotal`,
                    `t`.`Tour_Status`,
                    `t`.`Id_CategoryTour`,
                    `t`.`Id_TypeTour`,
                    `t`.`Id_Country`,
                    `t`.`Id_State`,
                    `t`.`Id_City`,

                    `b`.`Booking_Date`,
                    `b`.`Booking_Code`
            FROM (
                SELECT $select
                FROM `t_group_passenger` `gp`
                WHERE $where
            ) AS `frm_aux`
            INNER JOIN `t_booking_tour_passenger` `btp` ON `btp`.`Id_BookingTourPassenger` = `frm_aux`.`Id`
            INNER JOIN `t_passenger` `p` ON `p`.`Id_Passenger` = `btp`.`Id_Passenger`
            INNER JOIN `t_group` `g` ON `g`.`Id_Group` = `frm_aux`.`Id_Group`
            INNER JOIN `t_booking` `b` ON `b`.`Id_Booking` = `p`.`Id_Booking`
            LEFT JOIN `t_tour` `t` ON `t`.`Id_Tour` = `g`.`Id_Service` AND `g`.`Group_ServiceType` IN (1, 2)
            ORDER BY `frm_aux`.`GroupPassenger_MediaDateUpdate` DESC",
            $data
        );
    }

    private function findActionElement($action)
    {
        if (array_key_exists($action, $this->actionList)) {
            return $this->actionList[$action];
        }
        return $this->actionList['not_downloaded'];
    }

    protected function analize($data)
    {
        return array_map(fn ($data) => (object)[
            'Id_GroupPassenger' => $data->Id_GroupPassenger,
            'GroupPassenger_Type' => $data->GroupPassenger_Type,
            'GroupPassenger_Notification' => $data->GroupPassenger_Notification,
            'GroupPassenger_NotificationAccepted' => $data->GroupPassenger_NotificationAccepted,
            'GroupPassenger_ExternalReview' => $data->GroupPassenger_ExternalReview,
            'GroupPassenger_ReviewStatus' => $data->GroupPassenger_ReviewStatus,
            'GroupPassenger_ReviewDateUpdate' => $data->GroupPassenger_ReviewDateUpdate,
            'GroupPassenger_MediaDateUpdate' => $data->GroupPassenger_MediaDateUpdate,
            'GroupPassenger_MediaStatus' => $data->GroupPassenger_MediaStatus,
            'GroupPassenger_MediaScore' => $data->GroupPassenger_MediaScore,
            'GroupPassenger_MediaScoreDescription' => $data->GroupPassenger_MediaScoreDescription,
            'Id_Group' => $data->Id_Group,
            'Id_BookingTourPassenger' => $data->Id,

            'Passenger_DateCreate' => $data->Passenger_DateCreate,
            'Passenger_DateEdit' => $data->Passenger_DateEdit,
            'Passenger_Name' => $data->Passenger_Name,
            'Passenger_LastName' => $data->Passenger_LastName,
            'Passenger_Email' => $data->Passenger_Email,
            'Passenger_Phone' => $data->Passenger_Phone,
            'Passenger_PhoneCode' => $data->Passenger_PhoneCode,
            'Passenger_Gender' => $data->Passenger_Gender,
            'Passenger_DOB' => $data->Passenger_DOB,
            'Passenger_NoDocument' => $data->Passenger_NoDocument,
            'Passenger_DateEntrance' => $data->Passenger_DateEntrance,
            'Passenger_Restriction' => $data->Passenger_Restriction,
            'Passenger_Extras' => $data->Passenger_Extras,
            'Passenger_Order' => $data->Passenger_Order,
            'Passenger_ImgDocument1' => $data->Passenger_ImgDocument1,
            'Passenger_ImgDocument2' => $data->Passenger_ImgDocument2,
            'Passenger_Reportable' => $data->Passenger_Reportable,
            'Passenger_Status' => $data->Passenger_Status,
            'Passenger_PaymentStatus' => $data->Passenger_PaymentStatus,
            'Passenger_InfoStatus' => $data->Passenger_InfoStatus,
            'Passenger_CheckedInStatus' => $data->Passenger_CheckedInStatus,
            'Passenger_ConfirmMessage' => $data->Passenger_ConfirmMessage,
            'Passenger_Full' => $data->Passenger_Full,
            'Id_Booking' => $data->Id_Booking,
            'Id_TypeDocument' => $data->Id_TypeDocument,
            'Id_UserCountry' => $data->Id_UserCountry,
            'Id_TypeRate' => $data->Id_TypeRate,
            'Group_Date' => $data->Group_Date,
            'Group_DateUpdate' => $data->Group_DateUpdate,
            'Group_DateStart' => $data->Group_DateStart,
            'Group_DateEnd' => $data->Group_DateEnd,
            'Group_Hour' => $data->Group_Hour,
            'Group_Name' => $data->Group_Name,
            'Group_Token' => $data->Group_Token,
            'Group_Origin' => $data->Group_Origin,
            'Group_Destination' => $data->Group_Destination,
            'Group_Type' => $data->Group_Type,
            'Group_Order' => $data->Group_Order,
            'Group_TourDuration' => $data->Group_TourDuration,
            'Group_Remark' => $data->Group_Remark,
            'Group_MasterType' => $data->Group_MasterType,
            'Group_ServiceType' => $data->Group_ServiceType,
            'Group_NoValidPassengers' => $data->Group_NoValidPassengers,
            'Group_ValidPassengers' => $data->Group_ValidPassengers,
            'Group_Status' => $data->Group_Status,
            'Id_Master' => $data->Id_Master,
            'Id_Service' => $data->Id_Service,
            'Id_StatusGroup' => $data->Id_StatusGroup,
            'Id_Tour' => $data->Id_Tour,
            'Tour_Code' => $data->Tour_Code,
            'Tour_Name' => $data->Tour_Name,
            'Tour_UrlThumbnail' => $data->Tour_UrlThumbnail,
            'Tour_Duration' => $data->Tour_Duration,
            'Tour_MinPax' => $data->Tour_MinPax,
            'Tour_Availability' => $data->Tour_Availability,
            'Tour_AvailabilityStatus' => $data->Tour_AvailabilityStatus,
            'Tour_Anticipation' => $data->Tour_Anticipation,
            'Tour_AnticipationType' => $data->Tour_AnticipationType,
            'Tour_Color' => $data->Tour_Color,
            'Tour_Score' => $data->Tour_Score,
            'Tour_ScoreCant' => $data->Tour_ScoreCant,
            'Tour_ScoreTotal' => $data->Tour_ScoreTotal,
            'Tour_Status' => $data->Tour_Status,
            'Id_CategoryTour' => $data->Id_CategoryTour,
            'Id_TypeTour' => $data->Id_TypeTour,
            'Id_Country' => $data->Id_Country,
            'Id_State' => $data->Id_State,
            'Id_City' => $data->Id_City,
            'Booking_Date' => $data->Booking_Date,
            'Booking_Code' => $data->Booking_Code
        ], $data);
    }
}
