<?php

namespace App\Modules\GroupPassenger\Application\ReportCategorized;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReportCategorizedGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerCategorizedReporter $update)
    {
    }

    public function __invoke(ReportCategorizedGroupPassengerQuery $query): ReportCategorizedGroupPassengerResponse
    {
        return $this->update->__invoke(
            new GroupDateStart($query->dateStart()),
            new GroupDateEnd($query->dateEnd())
        );
    }
}
