<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Group\Domain\ReportGroupRepository;
use App\Modules\Shared\Domain\QueryList\ListInput;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlReportGroupRepository implements ReportGroupRepository {

    public function find(GroupDateStart $dateStart, GroupDateEnd $dateEnd, ListInput $list):array {
        return Requester::requestSelect(
            'CALL sp_group_report_paginated(?,?,?,?,@sts,@cod,@msg)',
            [
                $dateStart->value(),
                $dateEnd->value(),
                $list->getOffset(),
                $list->getLimit()
            ]
        );
    }

    public function count(GroupDateStart $dateStart, GroupDateEnd $dateEnd):int {
        $response = Requester::requestSelect(
            'CALL sp_group_report_paginated_count(?,?,@sts,@cod,@msg)',
            [
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
        if (count($response['Response_Data']) > 0) {
            return $response['Response_Data'][0]->amount;
        }
    }
}
