<?php

namespace App\Modules\Group\Domain;

class GroupStatus {

    public const NULLIFIED = 0;
    public const PENDING = 1;
    public const CONFIRMED = 2;
    public const FINALIZED = 3;

    private int $value;

    public function __construct(int $value) {
        $values = [self::NULLIFIED, self::PENDING, self::CONFIRMED, self::FINALIZED];
        $this->value = in_array($value, $values) ? $value : $values[0];
    }

    public function getValue() { return $this->value; }
}