<?php

namespace App\Modules\Group\Application\UpdateStatus;

use App\Modules\Group\Domain\GroupRepositoryAlter;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\StatusGroup\Domain\IdStatusGroup;

final class GroupStatusGroupUpdater
{
    public function __construct(
        private GroupRepositoryAlter $repository,
    ) {
    }

    public function __invoke(
        IdGroup $idGroup,
        IdStatusGroup $idStatusGroup
    ): UpdateGroupStatusQueryResponse {
        return new UpdateGroupStatusQueryResponse($this->repository->updateStatus($idGroup, $idStatusGroup));
    }
}
