<?php

namespace App\Modules\Group\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateGroupQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $hour,
        private string $origin,
        private string $destination,
        private int $type,
        private string $remark,
        private int $serviceType,
        private int $idService,
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function hour(): string
    {
        return $this->hour;
    }

    public function origin(): string
    {
        return $this->origin;
    }

    public function destination(): string
    {
        return $this->destination;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function remark(): string
    {
        return $this->remark;
    }

    public function serviceType(): int
    {
        return $this->serviceType;
    }

    public function idService(): int
    {
        return $this->idService;
    }
}
