<?php

namespace App\Modules\Flight\Application\Create;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Flight\Domain\Flight;
use App\Modules\Flight\Domain\FlightCarrier;
use App\Modules\Flight\Domain\FlightDateArrival;
use App\Modules\Flight\Domain\FlightDateDeparture;
use App\Modules\Flight\Domain\FlightDestination;
use App\Modules\Flight\Domain\FlightNumber;
use App\Modules\Flight\Domain\FlightObservation;
use App\Modules\Flight\Domain\FlightOrigin;
use App\Modules\Flight\Domain\FlightType;
use App\Modules\Flight\Domain\IdFlight;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class InsertFlightQueryHandler implements QueryHandler
{
    public function __construct(private FlightInserter $inserter)
    {
    }

    public function __invoke(InsertFlightQuery $query): InsertFlightResponse
    {
        $model = new Flight(
            new IdFlight($query->id()),
            new FlightDateDeparture($query->dateDeparture()),
            new FlightDateArrival($query->dateArrival()),
            new FlightOrigin($query->origin()),
            new FlightDestination($query->destination()),
            new FlightNumber($query->number()),
            new FlightCarrier($query->carrier()),
            new FlightObservation($query->observation()),
            new FlightType($query->type()),
            new IdBooking($query->idBooking()),
        );
        return $this->inserter->__invoke($model);
    }
}
