<?php

namespace App\Modules\FactUnit\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactUnit extends AggregateRoot
{

    public const VALUE = 'ZZ';

    public static function defaultValue()
    {
        return self::VALUE;
    }

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactUnit::class, 'Id_FactUnit'),
            new AggregateAttribute('name', FactUnitName::class, 'FactUnit_Name'),
            new AggregateAttribute('abrv', FactUnitAbrv::class, 'FactUnit_Abrv'),
            new AggregateAttribute('status', FactUnitStatus::class, 'FactUnit_Status')
        ];
    }

    public function __construct(
        private IdFactUnit $id,
        private FactUnitName $name,
        private FactUnitAbrv $abrv,
        private FactUnitStatus $status,
    ) {
    }

    public function id(): IdFactUnit
    {
        return $this->id;
    }

    public function name(): FactUnitName
    {
        return $this->name;
    }

    public function abrv(): FactUnitAbrv
    {
        return $this->abrv;
    }

    public function status(): FactUnitStatus
    {
        return $this->status;
    }
}
