<?php

namespace App\Modules\FactTypeReceipt\Application\Update;

use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceipt;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptAddress;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptContactName;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptContactPhone;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptEmail;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptGender;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptAbrv;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptName;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptNoDocument;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptPhone;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptPhoneCode;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptStatus;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class FactTypeReceiptUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeReceiptUpdater $updater)
    {
    }

    public function __invoke(FactTypeReceiptUpdaterQuery $query): FactTypeReceiptUpdaterResponse
    {
        $model = new FactTypeReceipt(
            new IdFactTypeReceipt($query->getId()),
            new FactTypeReceiptName($query->getName()),
            new FactTypeReceiptAbrv($query->getAbrv()),
            new FactTypeReceiptStatus($query->getStatus()),
        );
        return $this->updater->__invoke($model);
    }
}
