<?php

namespace App\Modules\FactReceiptDetail\Application\Update;

use App\Modules\FactProduct\Domain\FactProductCode;
use App\Modules\FactProduct\Domain\FactProductIdProduct;
use App\Modules\FactProduct\Domain\FactProductName;
use App\Modules\FactReceiptDetail\Domain\IdFactReceiptDetail;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailAmount;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailDiscount;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailTotal;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailUnitPrice;
use App\Modules\FactReceiptDetail\Domain\UpdateFactReceiptDetail;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactReceiptDetailUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptDetailUpdater $updater)
    {
    }

    public function __invoke(FactReceiptDetailUpdaterQuery $query): FactReceiptDetailUpdaterResponse
    {
        $model = new UpdateFactReceiptDetail(
            new IdFactReceiptDetail($query->id()),
            new FactReceiptDetailAmount($query->amount()),
            new FactReceiptDetailUnitPrice($query->unitPrice()),
            new FactReceiptDetailDiscount($query->discount()),
            new FactReceiptDetailTotal($query->total()),
            new IdFactTypeOperation($query->idFactTypeOperation()),
            new IdFactUnit($query->idFactUnit()),
            new FactProductCode($query->factProductCode()),
            new FactProductName($query->factProductName()),
            new FactProductIdProduct($query->factProductIdProduct()),
        );
        return $this->updater->__invoke($model);
    }
}
