<?php

namespace App\Modules\FactReceipt\Application\UpdateStatus;

use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptRepository;
use App\Modules\FactReceipt\Domain\UpdateStatusFactReceipt;

final class FactReceiptStatusUpdater
{
    public function __construct(private FactReceiptRepository $repository)
    {
    }

    public function __invoke(UpdateStatusFactReceipt $model)
    {
        return $this->repository->updateStatus($model);
    }
}
