<?php

namespace App\Modules\FactProduct\Domain;

use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactProduct extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactProduct::class, 'Id_FactProduct'),
            new AggregateAttribute('code', FactProductCode::class, 'FactProduct_Code'),
            new AggregateAttribute('name', FactProductName::class, 'FactProduct_Name'),
            new AggregateAttribute('idProduct', FactProductIdProduct::class, 'FactProduct_IdProduct'),
            new AggregateAttribute('status', FactProductStatus::class, 'FactProduct_Status'),
        ];
    }

    public function __construct(
        private IdFactProduct $id,
        private FactProductCode $code,
        private FactProductName $name,
        private FactProductIdProduct $idProduct,
        private FactProductStatus $status,
    ) {
    }

    public function value()
    {
        return $this->id->value();
    }

    public function id(): IdFactProduct
    {
        return $this->id;
    }

    public function code(): FactProductCode
    {
        return $this->code;
    }

    public function name(): FactProductName
    {
        return $this->name;
    }

    public function idProduct(): FactProductIdProduct
    {
        return $this->idProduct;
    }

    public function status(): FactProductStatus
    {
        return $this->status;
    }
}
