<?php

namespace App\Modules\FactProduct\Application\Index;

use App\Modules\FactProduct\Application\FactProductResponse;
use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactProductIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactProductIndexer $inserter)
    {
    }

    public function __invoke(FactProductIndexerQuery $query): FactProductResponse
    {
        $model = $this->inserter->__invoke(new IdFactProduct($query->getId()));
        return new FactProductResponse(
            $model->id()->value(),
            $model->code()->value(),
            $model->name()->value(),
            $model->idProduct()->value(),
            $model->status()->value(),
        );
    }
}
