<?php

namespace App\Modules\FactProduct\Application\Creator;

use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactProduct\Domain\FactProductCode;
use App\Modules\FactProduct\Domain\FactProductIdProduct;
use App\Modules\FactProduct\Domain\FactProductName;
use App\Modules\FactProduct\Domain\FactProductStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFactProductQueryHandler implements QueryHandler
{
    public function __construct(private FactProductCreator $updater)
    {
    }

    public function __invoke(CreateFactProductQuery $query): CreateFactProductResponse
    {
        $model = new FactProduct(
            new IdFactProduct($query->getId()),
            new FactProductCode($query->getCode()),
            new FactProductName($query->getName()),
            new FactProductIdProduct($query->getIdProduct()),
            new FactProductStatus($query->getStatus()),
        );
        return $this->updater->__invoke($model);
    }
}
