<?php

namespace App\Modules\FactPaymentMethod\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactPaymentMethod implements StorageCriteria
{

    public function __construct(
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactPaymentMethod::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactPaymentMethod_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactPaymentMethod_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactPaymentMethod_Status` = 0';
        } else {
            $where = '`ftd`.`FactPaymentMethod_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_payment_method` `ftd`
            WHERE $where",
            []
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
