<?php

namespace App\Modules\FactPaymentMethod\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactPaymentMethod implements StorageCriteria
{

    public function __construct(
        private IdFactPaymentMethod $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactPaymentMethod::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_fact_payment_method` `htc`
            WHERE `htc`.`Id_FactPaymentMethod` = ?
            AND `htc`.`FactPaymentMethod_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactPaymentMethodNotFound();
        }
        return $data[0];
    }
}
