<?php

namespace App\Modules\FactPaymentMethod\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactPaymentMethod extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactPaymentMethod::class, 'Id_FactPaymentMethod', 'primary'),
            new AggregateAttribute('name', FactPaymentMethodName::class, 'FactPaymentMethod_Name'),
            new AggregateAttribute('abrv', FactPaymentMethodAbrv::class, 'FactPaymentMethod_Abrv'),
            new AggregateAttribute('status', FactPaymentMethodStatus::class, 'FactPaymentMethod_Status'),
        ];
    }

    protected static function table(): string
    {
        return 't_fact_payment_method';
    }

    public function __construct(
        protected IdFactPaymentMethod $id,
        protected FactPaymentMethodName $name,
        protected FactPaymentMethodAbrv $abrv,
        protected FactPaymentMethodStatus $status,
    ) {
    }

    public function id(): IdFactPaymentMethod
    {
        return $this->id;
    }

    public function name(): FactPaymentMethodName
    {
        return $this->name;
    }

    public function abrv(): FactPaymentMethodAbrv
    {
        return $this->abrv;
    }

    public function status(): FactPaymentMethodStatus
    {
        return $this->status;
    }

    public function setName(FactPaymentMethodName $name): void
    {
        $this->name = $name;
    }

    public function setAbrv(FactPaymentMethodAbrv $abrv): void
    {
        $this->abrv = $abrv;
    }

    public function setStatus(FactPaymentMethodStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new FactPaymentMethodStatus(FactPaymentMethodStatus::DELETED);
    }
}
