<?php

namespace App\Modules\FactCurrency\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactCurrency implements StorageCriteria
{

    public function __construct(
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactCurrency::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactCurrency_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactCurrency_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactCurrency_Status` = 0';
        } else {
            $where = '`ftd`.`FactCurrency_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_currency` `ftd`
            WHERE $where",
            []
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
