<?php

namespace App\Modules\FactCurrency\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactCurrency implements StorageCriteria
{

    public function __construct(
        private IdFactCurrency $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactCurrency::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_fact_currency` `htc`
            WHERE `htc`.`Id_FactCurrency` = ?
            AND `htc`.`FactCurrency_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactCurrencyNotFound();
        }
        return $data[0];
    }
}
