<?php

namespace App\Modules\ExternalApiRequest\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class ExternalApiRequestNotFound extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            404,
            ErrorDictionary::ERRORS['OWNER']['EXTERNAL_API_REQUEST']['EXTERNAL_API_REQUEST_FIND']['EXTERNAL_API_REQUEST_NOT_FOUND'],
            'Solicitud de API externa no encontrado'
        );
    }
}
