<?php

namespace App\Modules\CashMovementFactReceipt\Application\Index;

use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponse;
use App\Modules\CashMovementFactReceipt\Domain\IdCashMovementFactReceipt;
use App\Modules\FactReceipt\Application\Index\FactReceiptIndexer;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexCashMovementFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(
        private CashMovementFactReceiptIndexer $indexer,
        private FactReceiptIndexer $factReceiptIndexer
    )
    {
    }

    public function __invoke(IndexCashMovementFactReceiptQuery $query): IndexCashMovementFactReceiptResponse
    {
        $model = $this->indexer->__invoke(new IdCashMovementFactReceipt($query->getId()));
        $factReceipt = $this->factReceiptIndexer->__invoke($model->idFactReceipt());
        return new IndexCashMovementFactReceiptResponse(
            $model->id()->value(),
            $model->status()->value(),
            $model->idCashMovement()->value(),
            $model->idFactReceipt()->value(),
            $factReceipt->date()->value(),
            $factReceipt->dateUpdate()->value(),
            $factReceipt->dateEmission()->value(),
            $factReceipt->noDocument()->value(),
            $factReceipt->businessName()->value(),
            $factReceipt->email()->value(),
            $factReceipt->address()->value(),
            $factReceipt->licensePlate()->value(),
            $factReceipt->currency()->value(),
            $factReceipt->responseMessage()->value(),
            $factReceipt->status()->value(),
            $factReceipt->idFactTypeReceipt()->value(),
            $factReceipt->idFactTypeDocument()->value(),
        );
    }
}
