<?php

namespace App\Modules\CashMovementFactReceipt\Application\GetCurrent;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;
use App\Modules\CashMovementFactReceipt\Domain\CurrentCashMovementFactReceipt;

final class CashMovementFactReceiptCurrentGetter
{
    public function __construct(private CashMovementFactReceiptRepository $repository)
    {
    }

    public function __invoke(IdCashMovement $idCashMovement)
    {
        $index = $this->repository->find(new CurrentCashMovementFactReceipt($idCashMovement));
        return $index;
    }
}
