<?php

namespace App\Modules\CashMovement\Application\Delete;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteCashMovementQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementDeleter $inserter)
    {
    }

    public function __invoke(DeleteCashMovementQuery $query): DeleteCashMovementResponse
    {
        return $this->inserter->__invoke(new IdCashMovement($query->id()));
    }
}
