<?php

namespace App\Modules\Briefing\Application\List;

use App\Modules\Briefing\Domain\BriefingOrderBy;
use App\Modules\Briefing\Domain\BriefingRepository;
use App\Modules\Briefing\Domain\BriefingType;
use App\Modules\Briefing\Domain\ListBriefing;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class BriefingLister
{
    public function __construct(private BriefingRepository $repository)
    {
    }

    public function __invoke(
        DateTimeStart $dateTimeStart,
        DateTimeEnd $dateTimeEnd,
        BriefingType $type,
        BriefingOrderBy $orderBy,
    )
    {
        return $this->repository->search(new ListBriefing(
            $dateTimeStart,
            $dateTimeEnd,
            $type,
            $orderBy,
            false
        ));
    }
}
