<?php

namespace App\Modules\BookingUpgradePassenger\Application\Reset;

use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ResetBookingUpgradePassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingUpgradePassengerResetter $resetter)
    {
    }

    public function __invoke(ResetBookingUpgradePassengerQuery $query): ResetBookingUpgradePassengerResponse
    {
        return $this->resetter->__invoke(new IdBookingUpgradePassenger($query->id()));
    }
}
