<?php

namespace App\Modules\BookingUpgradePassenger\Application\ListById;

use App\Modules\BookingUpgradePassenger\Application\BookingUpgradePassengerResponse;
use App\Modules\BookingUpgradePassenger\Application\BookingUpgradePassengerResponses;
use App\Modules\BookingUpgradePassenger\Domain\ListBookingUpgradePassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByIdBookingUpgradePassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingUpgradePassengerByIdLister $lister)
    {
    }

    public function __invoke(ListByIdBookingUpgradePassengerQuery $query): BookingUpgradePassengerResponses
    {
        return new BookingUpgradePassengerResponses(...array_map(
            fn (ListBookingUpgradePassenger $index) => new BookingUpgradePassengerResponse(
                $index->id()->value(),
                $index->is23MigrationValue()->value(),
                $index->date()->value(),
                $index->dateOnlyReturn()->value(),
                $index->dateEntry()->value(),
                $index->dateReturn()->value(),
                $index->datePurchase()->value(),
                $index->carrier()->value(),
                $index->code()->value(),
                $index->amount()->value(),

                $index->roundCarrier()->value(),
                $index->roundCode()->value(),
                $index->roundAmount()->value(),

                $index->remark()->value(),
                $index->mask()->value(),
                $index->status()->value(),
                $index->idProvider()->value(),
                $index->idProviderReturn()->value(),
                $index->idAdmin()->value(),
                $index->idBookingUpgrade()->value(),
                $index->idBookingTourPassenger()->value(),

                $index->idPassenger()->value(),
                $index->passengerGender()->value(),
                $index->passengerName()->value(),
                $index->passengerLastName()->value(),
                $index->idBookingTour()->value(),
                $index->bookingTourTourName()->value(),
                $index->bookingTourDateStart()->value(),
                $index->bookingTourTourDuration()->value(),
                $index->idBooking()->value(),
                $index->bookingCode()->value(),
                $index->bookingInternalRemark()->value(),
                $index->bookingObservation()->value(),
                $index->idUserCountry()->value(),
                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB') . $index->userCountryImg()->value(),
                $index->userCountryName()->value()
            ),
            $this->lister->__invoke($query->ids())
        ));
    }
}
