<?php

namespace App\Modules\BookingUpgradePassenger\Application\ListById;

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Domain\ListByIdBookingUpgradePassenger;

final class BookingUpgradePassengerByIdLister
{
    public function __construct(private BookingUpgradePassengerRepository $repository)
    {
    }

    public function __invoke(array $ids)
    {
        return $this->repository->search(new ListByIdBookingUpgradePassenger($ids));
    }
}
