<?php

namespace App\Modules\BookingUpgradePassenger\Application\Index;

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;

final class BookingUpgradePassengerIndexer
{
    public function __construct(private BookingUpgradePassengerRepository $repository)
    {
    }

    public function __invoke(int $id)
    {
        return $this->repository->index(new IdBookingUpgradePassenger($id));
    }
}
