<?php

namespace App\Modules\BookingTourPassenger\Domain;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Passenger\Domain\IdPassenger;

interface BookingTourPassengerRepository
{

    public function find($criteria): BookingTourPassenger;
    /** @return array<BookingTourPassenger> */
    public function search($criteria): array;
    public function update(BookingTourPassenger $bookingTourPassenger);
    public function index(IdBookingTourPassenger $idBookingTourPassenger);
    public function listByPassenger(IdPassenger $idPassenger, string $action);
    public function listByCashMovement(IdCashMovement $idCashMovement, string $action);
    public function bookingTourPassengerGroupsValidation(IdBookingTourPassenger $idBookingTourPassenger);
    public function cancel(IdBookingTourPassenger $idBookingTourPassenger);
    public function activate(IdBookingTourPassenger $idBookingTourPassenger);
    public function updatePartial(BookingTourPassengerModel $bookingTourPassenger);
}
