<?php

namespace App\Modules\BookingTourPassenger\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class BookingTourPassengerModel extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdBookingTourPassenger::class, 'Id_BookingTourPassenger', 'primary'),
            new AggregateAttribute('lock', BookingTourPassengerLock::class, 'BookingTourPassenger_Lock'),
            new AggregateAttribute('reportable', BookingTourPassengerReportable::class, 'BookingTourPassenger_Reportable'),
            new AggregateAttribute('hotel', BookingTourPassengerHotel::class, 'BookingTourPassenger_Hotel'),
            new AggregateAttribute('remark', BookingTourPassengerRemark::class, 'BookingTourPassenger_Remark'),
            new AggregateAttribute('price', BookingTourPassengerPrice::class, 'BookingTourPassenger_Price'),
            new AggregateAttribute('full', BookingTourPassengerFull::class, 'BookingTourPassenger_Full'),
            new AggregateAttribute('validGroups', BookingTourPassengerValidGroups::class, 'BookingTourPassenger_ValidGroups'),
            new AggregateAttribute('noValidGroups', BookingTourPassengerNoValidGroups::class, 'BookingTourPassenger_NoValidGroups'),
            new AggregateAttribute('hasBeenPrinted', BookingTourPassengerHasBeenPrinted::class, 'BookingTourPassenger_HasBeenPrinted'),
            new AggregateAttribute('status', BookingTourPassengerStatus::class, 'BookingTourPassenger_Status'),
            new AggregateAttribute('paymentStatus', BookingTourPassengerPaymentStatus::class, 'BookingTourPassenger_PaymentStatus'),
            new AggregateAttribute('idBookingTour', IdBookingTour::class, 'Id_BookingTour'),
            new AggregateAttribute('idPassenger', IdPassenger::class, 'Id_Passenger'),
        ];
    }

    protected static function table(): string
    {
        return 't_booking_tour_passenger';
    }

    public function __construct(
        protected IdBookingTourPassenger $id,
        protected BookingTourPassengerLock $lock,
        protected BookingTourPassengerReportable $reportable,
        protected BookingTourPassengerHotel $hotel,
        protected BookingTourPassengerRemark $remark,
        protected BookingTourPassengerPrice $price,
        protected BookingTourPassengerFull $full,
        protected BookingTourPassengerValidGroups $validGroups,
        protected BookingTourPassengerNoValidGroups $noValidGroups,
        protected BookingTourPassengerHasBeenPrinted $hasBeenPrinted,
        protected BookingTourPassengerStatus $status,
        protected BookingTourPassengerPaymentStatus $paymentStatus,
        protected IdBookingTour $idBookingTour,
        protected IdPassenger $idPassenger,
    ) {
    }

    public function id(): IdBookingTourPassenger
    {
        return $this->id;
    }

    public function lock(): BookingTourPassengerLock
    {
        return $this->lock;
    }

    public function reportable(): BookingTourPassengerReportable
    {
        return $this->reportable;
    }

    public function hotel(): BookingTourPassengerHotel
    {
        return $this->hotel;
    }

    public function remark(): BookingTourPassengerRemark
    {
        return $this->remark;
    }

    public function price(): BookingTourPassengerPrice
    {
        return $this->price;
    }

    public function full(): BookingTourPassengerFull
    {
        return $this->full;
    }

    public function validGroups(): BookingTourPassengerValidGroups
    {
        return $this->validGroups;
    }

    public function noValidGroups(): BookingTourPassengerNoValidGroups
    {
        return $this->noValidGroups;
    }

    public function hasBeenPrinted(): BookingTourPassengerHasBeenPrinted
    {
        return $this->hasBeenPrinted;
    }

    public function status(): BookingTourPassengerStatus
    {
        return $this->status;
    }

    public function paymentStatus(): BookingTourPassengerPaymentStatus
    {
        return $this->paymentStatus;
    }

    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }

    public function idPassenger(): IdPassenger
    {
        return $this->idPassenger;
    }

    public function isLocked(): bool
    {
        return $this->lock->value() === BookingTourPassengerLock::activeValue();
    }

    public function setReportable(BookingTourPassengerReportable $reportable): void
    {
        $this->reportable = $reportable;
    }

    public function setLock(BookingTourPassengerLock $lock): void
    {
        $this->lock = $lock;
    }

    public function setHotel(BookingTourPassengerHotel $hotel): void
    {
        $this->hotel = $hotel;
    }

    public function setStatus(BookingTourPassengerStatus $status): void
    {
        $this->status = $status;
    }

    public function setRemark(BookingTourPassengerRemark $remark): void
    {
        $this->remark = $remark;
    }

    public function setHasBeenPrinted(BookingTourPassengerHasBeenPrinted $hasBeenPrinted): void
    {
        $this->hasBeenPrinted = $hasBeenPrinted;
    }
}
