<?php

namespace App\Modules\BookingTourPassenger\Application\Index;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingTourPassengerIndexer $changer)
    {
    }

    public function __invoke(IndexBookingTourPassengerQuery $query): IndexBookingTourPassengerResponse
    {
        return $this->changer->__invoke(
            new IdBookingTourPassenger($query->id())
        );
    }
}
