<?php

namespace App\Modules\BookingTourPassenger\Application\ChangeStatus;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerStatus;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ChangeStatusBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingTourPassengerStatusChanger $changer)
    {
    }

    public function __invoke(ChangeStatusBookingTourPassengerQuery $query): ChangeStatusBookingTourPassengerResponse
    {
        return $this->changer->__invoke(
            new IdBookingTourPassenger($query->id()),
            new BookingTourPassengerStatus($query->status())
        );
    }
}
