<?php

namespace App\Modules\BookingTourItem\Application\ListEquipment;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourItem\Application\List\BookingTourItemListerResponse;
use App\Modules\BookingTourItem\Domain\EquipmentRepository;

final class EquipmentLister
{
    public function __construct(private EquipmentRepository $repository)
    {
    }

    public function __invoke(IdBookingTour $idBookingTour, string $action): BookingTourItemListerResponse
    {
        return new BookingTourItemListerResponse($this->repository->find($idBookingTour, $action));
    }
}
