<?php

namespace App\Modules\BookingTour\Application\UpdateGroup;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingTour\Domain\BookingTourFeeType;
use App\Modules\BookingTour\Domain\BookingTourFull;
use App\Modules\BookingTour\Domain\BookingTourGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateGroupBookingTourQueryHandler implements QueryHandler
{
    public function __construct(
        private BookingTourGroupUpdater $updater,
    ) {
    }

    public function __invoke(UpdateGroupBookingTourQuery $query): UpdateGroupBookingTourQueryResponse
    {
        return $this->updater->__invoke(
            new IdBooking($query->idBooking()),
            new BookingTourGroup($query->group()),
            new BookingTourFeeType($query->feeType()),
            new BookingTourFull($query->full())
        );
    }
}
