<?php

namespace App\Modules\BookingTour\Application;

class BookingTourPassengerGrouperByGroup
{
    public function __construct()
    {
    }

    public function __invoke(array $passengers, string $date)
    {
        return array_reduce(
            $passengers,
            fn($carry, $passenger) => $this->groupPassenger($carry, $passenger, $date),
            []
        );
    }

    private function groupPassenger($carry, $passenger, $date)
    {
        if ($passenger->Id_Group === null) {
            return $carry;
        }
        
        $found = array_filter($carry, fn($notification) => $notification->Id == $passenger->Id_Group);
        
        if (!count($found)) {
            $carry[] = (object)[
                'Id' => $passenger->Id_Group,
                'Notification_Description' => $this->getNotificationText($passenger, $date)
            ];
        } else {
            $found[0]->Notification_Description .= $this->getPassengerName($passenger);
        }
        return $carry;
    }

    public function getNotificationText($passenger, $date)
    {
        return 'Ha cambiado la fecha del tour a : <strong>' . $date . '</strong>, reasigne a los siguientes pasajeros :'
            . $this->getPassengerName($passenger);
    }

    private function getPassengerName($passenger)
    {
        return '<br /> - ' . $passenger->Passenger_Name . ' ' . $passenger->Passenger_LastName;
    }
}
