<?php

namespace App\Modules\BookingExtraPassenger\Application\Reset;

use App\Modules\BookingExtraPassenger\Domain\IdBookingExtraPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ResetBookingExtraPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingExtraPassengerResetter $resetter)
    {
    }

    public function __invoke(ResetBookingExtraPassengerQuery $query): ResetBookingExtraPassengerResponse
    {
        return $this->resetter->__invoke(new IdBookingExtraPassenger($query->id()));
    }
}
