<?php

namespace App\Modules\BookingExtraPassenger\Application\Mask;

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerMask;
use App\Modules\BookingExtraPassenger\Domain\IdBookingExtraPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class MaskBookingExtraPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingExtraPassengerMasker $masker)
    {
    }

    public function __invoke(MaskBookingExtraPassengerQuery $query): MaskBookingExtraPassengerResponse
    {
        return $this->masker->__invoke(
            new IdBookingExtraPassenger($query->id()),
            new BookingExtraPassengerMask($query->mask())
        );
    }
}
