<?php

namespace App\Modules\BookingCalendar\Application\ListPassenger;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class ListPassengerBookingCalendarQueryHandler implements QueryHandler
{
    public function __construct(private BookingCalendarPassengerLister $lister)
    {
    }

    public function __invoke(ListPassengerBookingCalendarQuery $query): ListPassengerBookingCalendarResponse
    {
        return $this->lister->__invoke(
            new IdTour($query->idTour()),
            new DateStart($query->dateStart())
        );
    }
}
