<?php

namespace App\Modules\BookingAssign\Application\Index;

use App\Modules\BookingAssign\Application\Index\IndexBookingAssignQueryResponse;
use App\Modules\BookingAssign\Domain\IdBookingAssign;
use App\Modules\BookingAssign\Domain\BookingAssign;
use App\Modules\BookingAssign\Domain\BookingAssignRepository;

final class BookingAssignIndexer
{
    public function __construct(private BookingAssignRepository $repository)
    {
    }

    public function __invoke(IdBookingAssign $idBookingAssign): IndexBookingAssignQueryResponse
    {
        return new IndexBookingAssignQueryResponse($this->repository->index($idBookingAssign));
    }
}
