<?php

namespace App\Modules\BookingAssign\Application\Delete;

use App\Modules\BookingAssign\Application\Delete\BookingAssignDeleterResponse;
use App\Modules\BookingAssign\Domain\IdBookingAssign;
use App\Modules\BookingAssign\Domain\BookingAssignRepository;

final class BookingAssignDeleter
{
    public function __construct(private BookingAssignRepository $repository)
    {
    }

    public function __invoke(IdBookingAssign $idBookingAssign): DeleteBookingAssignQueryResponse
    {
        return new DeleteBookingAssignQueryResponse($this->repository->delete($idBookingAssign));
    }
}
