<?php

namespace App\Modules\BookingAdditional\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateBookingAdditionalQuery implements Query
{
    public function __construct(
        private int $id,
        private string $name,
        private string $abrv,
        private int $type,
        private int $status,
        private int $idBookingTourPassenger,
        private int $idInternal
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function name(): string
    {
        return $this->name;
    }

    public function abrv(): string
    {
        return $this->abrv;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idBookingTourPassenger(): int
    {
        return $this->idBookingTourPassenger;
    }

    public function idInternal(): int
    {
        return $this->idInternal;
    }
}
