<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Passenger\Domain\PassengerDOB;
use App\Modules\Passenger\Domain\PassengerEmail;
use App\Modules\Passenger\Domain\PassengerGender;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Passenger\Domain\PassengerPhone;
use App\Modules\Passenger\Domain\PassengerStatus;

/** Encapsula los datos a exportar en excel del booking */
class ReportPassenger {

    private PassengerName $passengerName;
    private PassengerLastName $passengerLastName;
    private PassengerEmail $passengerEmail;
    private PassengerPhone $passengerPhone;
    private PassengerStatus $passengerStatus;
    private PassengerDOB $passengerDOB;
    private PassengerGender $passengerGender;

    /** constructor */
    public function __construct (
        PassengerName $passengerName,
        PassengerLastName $passengerLastName,
        PassengerEmail $passengerEmail,
        PassengerPhone $passengerPhone,
        PassengerStatus $passengerStatus,
        PassengerDOB $passengerDOB,
        PassengerGender $passengerGender
    ) {
        
        $this->passengerName = $passengerName;
        $this->passengerLastName = $passengerLastName;
        $this->passengerEmail = $passengerEmail;
        $this->passengerPhone = $passengerPhone;
        $this->passengerStatus = $passengerStatus;
        $this->passengerDOB = $passengerDOB;
        $this->passengerGender = $passengerGender;
    }

    public function getName():PassengerName { return $this->passengerName; }
    public function getLastName():PassengerLastName { return $this->passengerLastName; }
    public function getEmail():PassengerEmail { return $this->passengerEmail; }
    public function getPhone():PassengerPhone { return $this->passengerPhone; }
    public function getStatus():PassengerStatus { return $this->passengerStatus; }
    public function getDOB():PassengerDOB { return $this->passengerDOB; }
    public function getGender():PassengerGender { return $this->passengerGender; }

}