<?php

namespace App\Modules\Booking\Domain;

use App\Modules\BookingTour\Domain\BookingTourDateStart;
use App\Modules\BookingTour\Domain\BookingTourTourName;
use App\Modules\BookingTour\Domain\BookingTourName;
use App\Modules\BookingTour\Domain\BookingTourNoPax;
use App\Modules\BookingTour\Domain\BookingTourTourDuration;
use App\Modules\BookingTour\Domain\BookingTourTourDurationCode;
use App\Modules\BookingTour\Domain\BookingTourStatus;

/** Encapsula los datos a exportar en excel del booking */
class ReportBookingTour {

    private BookingTourName $bookingTourName;
    private BookingTourTourName $bookingTourTourName;
    private BookingTourNoPax $bookingTourNoPax;
    private BookingTourDateStart $bookingTourDateStart;
    private BookingTourTourDuration $bookingTourTourDuration;
    private BookingTourStatus $bookingTourStatus;
    

    /** constructor */
    public function __construct (
        BookingTourName $bookingTourName,
        BookingTourTourName $bookingTourTourName,
        BookingTourNoPax $bookingTourNoPax,
        BookingTourDateStart $bookingTourDateStart,
        BookingTourTourDuration $bookingTourTourDuration,
        BookingTourStatus $bookingTourStatus
    ) {
        
        $this->bookingTourName = $bookingTourName;
        $this->bookingTourTourName = $bookingTourTourName;
        $this->bookingTourNoPax = $bookingTourNoPax;
        $this->bookingTourDateStart = $bookingTourDateStart;
        $this->bookingTourTourDuration = $bookingTourTourDuration;
        $this->bookingTourStatus = $bookingTourStatus;
    }

    public function getName():BookingTourName { return $this->bookingTourName; }
    public function getTourName():BookingTourTourName { return $this->bookingTourTourName; }
    public function getNoPax():BookingTourNoPax { return $this->bookingTourNoPax; }
    public function getDateStart():BookingTourDateStart { return $this->bookingTourDateStart; }
    public function getTourDuration():BookingTourTourDuration { return $this->bookingTourTourDuration; }
    public function getStatus():BookingTourStatus { return $this->bookingTourStatus; }
}