<?php

namespace App\Modules\Booking\Domain;

class BookingType
{

    public const RESERVA_WEB = 1;
    public const RESERVA_SISTEMA = 2;
    public const RESERVA_WHATSAPP = 3;
    public const RESERVA_INSTAGRAM = 4;
    public const RESERVA_PHONE = 5;
    public const RESERVA_GOOGLE_BUSINESS = 6;
    public const RESERVA_MESSENGER = 7;
    public const RESERVA_OFFICE = 8;
    public const RESERVA_VIATOR = 9;

    private int $value;

    public function __construct(int $value)
    {
        $this->value = $value;
    }

    public function getValue()
    {
        return $this->value;
    }

    public function value()
    {
        return $this->value;
    }

    public static function getBookingType($booking)
    {
        if ($booking->User_Type == 2) {
            return 'ENDOSADOR';
        } else {
            if ($booking->Booking_Type == 1) {
                return 'WEB';
            } else {
                if ($booking->Booking_InPerson == 2) {
                    return 'OFICINA';
                } else {
                    return 'CORREO';
                }
            }
        }
    }
}
