<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

interface BookingRepository
{
    public function searchConfirm(DateStart $dateStart, DateEnd $dateEnd, string $orderBy);
    public function searchConfirmExcel(DateStart $dateStart, DateEnd $dateEnd, string $orderBy);
    public function search(BookingCode $code);
    public function getReportExcel(ReportExcelRequirements $requirements);
    public function updateManuallyConfirmed(UpdateManuallyConfirmedBooking $model);
}
