<?php

namespace App\Modules\Booking\Application\SearchConfirmExcel;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class SearchConfirmExcelBookingQueryHandler implements QueryHandler
{
    public function __construct(private BookingConfirmExcelSearcher $lister)
    {
    }

    public function __invoke(SearchConfirmExcelBookingQuery $query): SearchConfirmExcelBookingResponse
    {
        return $this->lister->__invoke(
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->orderBy()
        );
    }
}
