<?php

namespace App\Modules\Booking\Application\SearchConfirmExcel;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class SearchConfirmExcelBookingQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd,
        private string $orderBy,
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function dateEnd(): string
    {
        return $this->dateEnd;
    }

    public function orderBy(): string
    {
        return $this->orderBy;
    }
}
